<?php
// اعمال تخفیف 20% و 10% به قیمت محصول
$discount_20 = 20;  // تخفیف 20%
$discount_10 = 10;  // تخفیف 10%

$discount_20_amount = ($product_price * $discount_20) / 100;  // 20% از قیمت
$discount_10_amount = ($product_price * $discount_10) / 100;  // 10% از قیمت

$final_price = $product_price - $discount_20_amount - $discount_10_amount;  // قیمت نهایی بعد از تخفیف‌ها

// نمایش قیمت نهایی
echo "تخفیف 20%: " . number_format($discount_20_amount) . " تومان<br>";
echo "تخفیف 10%: " . number_format($discount_10_amount) . " تومان<br>";
echo "قیمت نهایی: " . number_format($final_price) . " تومان<br>";

// فرض می‌کنیم که کاربر وارد حساب کاربری خود شده است و user_id او 1 است
$user_id = 1;  // شناسه کاربر

// دریافت موجودی کیف پول کاربر
$sql = "SELECT wallet_balance FROM users WHERE user_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$user_result = $stmt->get_result();
$user = $user_result->fetch_assoc();
$current_balance = $user['wallet_balance'];

// اضافه کردن مبلغ به کیف پول
$new_balance = $current_balance + $final_price;

// بروز رسانی موجودی کیف پول کاربر
$sql = "UPDATE users SET wallet_balance = ? WHERE user_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("di", $new_balance, $user_id);
$stmt->execute();

// نمایش موجودی جدید کیف پول
echo "موجودی کیف پول شما پس از شارژ: " . number_format($new_balance) . " تومان<br>";
?>
