<?php
include('db_connection.php');
session_start();

// بررسی اینکه کاربر وارد سیستم شده است
if (!isset($_SESSION['user_id'])) {
    die("لطفاً وارد حساب کاربری خود شوید.");
}

$user_id = $_SESSION['user_id'];
$amount = $_POST['amount'];
$transaction_type = $_POST['transaction_type'];
$description = $_POST['description'];

// گرفتن موجودی فعلی کاربر
$sql_balance = "SELECT balance FROM users WHERE user_id = ?";
$stmt_balance = $conn->prepare($sql_balance);
$stmt_balance->bind_param("i", $user_id);
$stmt_balance->execute();
$result_balance = $stmt_balance->get_result();
$user = $result_balance->fetch_assoc();
$current_balance = $user['balance'];

// انجام تراکنش
if ($transaction_type == 'deposit') {
    // واریز پول به حساب
    $new_balance = $current_balance + $amount;
    $sql_transaction = "INSERT INTO transactions (user_id, amount, transaction_type, description) 
                        VALUES (?, ?, 'deposit', ?)";
} elseif ($transaction_type == 'withdrawal') {
    // برداشت پول از حساب
    if ($amount > $current_balance) {
        die("موجودی کافی برای برداشت وجود ندارد.");
    }
    $new_balance = $current_balance - $amount;
    $sql_transaction = "INSERT INTO transactions (user_id, amount, transaction_type, description) 
                        VALUES (?, ?, 'withdrawal', ?)";
} elseif ($transaction_type == 'transfer') {
    // انتقال پول (برای سادگی فرض می‌کنیم انتقال به خود کاربر است)
    $new_balance = $current_balance - $amount;
    $sql_transaction = "INSERT INTO transactions (user_id, amount, transaction_type, description) 
                        VALUES (?, ?, 'transfer', ?)";
}

// ثبت تراکنش
$stmt_transaction = $conn->prepare($sql_transaction);
$stmt_transaction->bind_param("ids", $user_id, $amount, $description);
$stmt_transaction->execute();

// به‌روزرسانی موجودی کاربر
$sql_update_balance = "UPDATE users SET balance = ? WHERE user_id = ?";
$stmt_update_balance = $conn->prepare($sql_update_balance);
$stmt_update_balance->bind_param("di", $new_balance, $user_id);
$stmt_update_balance->execute();

echo "تراکنش با موفقیت انجام شد.";
?>
