<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.html"); // اگر لاگین نکرده بود، برگرده به فرم ورود
    exit();
}
?>

<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <title>پنل کاربری</title>
</head>
<body>
    <h2>سلام <?php echo htmlspecialchars($_SESSION['user_name']); ?> عزیز!</h2>
    <p>شما وارد حساب کاربری خود شدید.</p>
    <a href="logout.php">خروج از حساب</a>
</body>
</html>
<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.html");
    exit();
}

$host = "localhost";
$dbname = "user_registration";
$username = "root";
$password = "";

try {
    $conn = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $stmt = $conn->prepare("SELECT * FROM users WHERE id = :id");
    $stmt->execute([':id' => $_SESSION['user_id']]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        echo "کاربر یافت نشد.";
        exit();
    }
} catch (PDOException $e) {
    echo "خطا: " . $e->getMessage();
    exit();
}
?>

<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <title>پنل کاربری</title>
</head>
<body>
    <h2>خوش آمدی <?php echo htmlspecialchars($user['first_name']); ?></h2>
    
    <img src="uploads/<?php echo $user['avatar']; ?>" alt="آواتار" width="100"><br><br>
    <strong>نام:</strong> <?php echo htmlspecialchars($user['first_name']); ?><br>
    <strong>نام خانوادگی:</strong> <?php echo htmlspecialchars($user['last_name']); ?><br>
    <strong>کد ملی:</strong> <?php echo htmlspecialchars($user['national_id']); ?><br><br>

    <h3>ویرایش اطلاعات</h3>
    <form action="update_profile.php" method="post" enctype="multipart/form-data">
        <label>نام:</label><br>
        <input type="text" name="first_name" value="<?php echo $user['first_name']; ?>" required><br>

        <label>نام خانوادگی:</label><br>
        <input type="text" name="last_name" value="<?php echo $user['last_name']; ?>" required><br>

        <label>کد ملی:</label><br>
        <input type="text" name="national_id" value="<?php echo $user['national_id']; ?>" required><br>

        <label>تصویر جدید (اختیاری):</label><br>
        <input type="file" name="avatar"><br><br>

        <input type="submit" value="ذخیره تغییرات">
    </form>

    <br><a href="logout.php">خروج از حساب</a>
</body>
</html>
