<?php
include('db_connection.php');
session_start();

// اطلاعات دریافتی از زرین‌پال
$merchantID = "your_merchant_id";  // MerchantID شما
$authority = $_GET['Authority'];  // شماره تراکنش
$status = $_GET['Status'];  // وضعیت تراکنش

if ($status == 'OK') {
    // دریافت اطلاعات کاربر از سشن
    $user_id = $_SESSION['user_id'];
    $amount = $_SESSION['amount'];  // مبلغ پرداختی که از سشن گرفته می‌شود
    $payment_id = $_GET['Authority'];  // شناسه پرداخت
    $payment_date = date('Y-m-d H:i:s');  // تاریخ و زمان پرداخت
    $usage_count = 1;  // تعداد استفاده (برای مثال، هر اشتراک یکبار استفاده است)

    // ثبت فاکتور در دیتابیس
    $sql = "INSERT INTO invoices (user_id, payment_id, payment_date, amount, usage_count, status)
            VALUES (?, ?, ?, ?, ?, 'paid')";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("issdi", $user_id, $payment_id, $payment_date, $amount, $usage_count);
    $stmt->execute();

    // فاکتور ثبت شد، حالا می‌توانیم فاکتور را نمایش دهیم
    echo "پرداخت با موفقیت انجام شد. شناسه پیگیری: " . $payment_id;
    echo "<br>فاکتور شما آماده است.";

    // نمایش فاکتور
    displayInvoice($user_id, $payment_id);
} else {
    echo "پرداخت با مشکل مواجه شد. لطفاً دوباره تلاش کنید.";
}

// تابع نمایش فاکتور
function displayInvoice($user_id, $payment_id) {
    global $conn;

    // دریافت اطلاعات کاربر
    $sql_user = "SELECT first_name, last_name, username FROM users WHERE user_id = ?";
    $stmt_user = $conn->prepare($sql_user);
    $stmt_user->bind_param("i", $user_id);
    $stmt_user->execute();
    $result_user = $stmt_user->get_result();
    $user = $result_user->fetch_assoc();

    // دریافت اطلاعات فاکتور
    $sql_invoice = "SELECT * FROM invoices WHERE user_id = ? AND payment_id = ?";
    $stmt_invoice = $conn->prepare($sql_invoice);
    $stmt_invoice->bind_param("is", $user_id, $payment_id);
    $stmt_invoice->execute();
    $result_invoice = $stmt_invoice->get_result();
    $invoice = $result_invoice->fetch_assoc();

    // نمایش فاکتور
    echo "<h2>فاکتور اشتراک ویژه</h2>";
    echo "<table border='1' cellpadding='5' cellspacing='0'>";
    echo "<tr><th>نام و نام خانوادگی</th><td>" . $user['first_name'] . " " . $user['last_name'] . "</td></tr>";
    echo "<tr><th>نام کاربری</th><td>" . $user['username'] . "</td></tr>";
    echo "<tr><th>شناسه پرداخت</th><td>" . $invoice['payment_id'] . "</td></tr>";
    echo "<tr><th>تاریخ پرداخت</th><td>" . $invoice['payment_date'] . "</td></tr>";
    echo "<tr><th>مبلغ</th><td>" . number_format($invoice['amount']) . " تومان</td></tr>";
    echo "<tr><th>تعداد استفاده</th><td>" . $invoice['usage_count'] . "</td></tr>";
    echo "</table>";
}
?>
<style>
    body {
        font-family: Arial, sans-serif;
        line-height: 1.6;
    }
    h2 {
        text-align: center;
        color: #333;
    }
    table {
        width: 80%;
        margin: 20px auto;
        border-collapse: collapse;
    }
    th, td {
        padding: 10px;
        text-align: left;
        border: 1px solid #ddd;
    }
    th {
        background-color: #f4f4f4;
        color: #333;
    }
    td {
        background-color: #f9f9f9;
    }
</style>
