<?php
include('db_connection.php');
session_start();

// بررسی اینکه کاربر وارد سیستم شده است
if (!isset($_SESSION['user_id'])) {
    die("لطفاً وارد حساب کاربری خود شوید.");
}

$user_id = $_SESSION['user_id'];

// گرفتن تاریخچه تراکنش‌ها
$sql_transactions = "SELECT * FROM transactions WHERE user_id = ? ORDER BY transaction_date DESC";
$stmt_transactions = $conn->prepare($sql_transactions);
$stmt_transactions->bind_param("i", $user_id);
$stmt_transactions->execute();
$result_transactions = $stmt_transactions->get_result();

// نمایش تاریخچه تراکنش‌ها
echo "<h2>تاریخچه تراکنش‌ها</h2>";
echo "<table border='1' cellpadding='5' cellspacing='0'>";
echo "<tr><th>شناسه تراکنش</th><th>مقدار</th><th>نوع تراکنش</th><th>توضیحات</th><th>تاریخ</th></tr>";
while ($row = $result_transactions->fetch_assoc()) {
    echo "<tr>";
    echo "<td>" . $row['transaction_id'] . "</td>";
    echo "<td>" . number_format($row['amount']) . " تومان</td>";
    echo "<td>" . ucfirst($row['transaction_type']) . "</td>";
    echo "<td>" . $row['description'] . "</td>";
    echo "<td>" . $row['transaction_date'] . "</td>";
    echo "</tr>";
}
echo "</table>";
?>
