<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.html");
    exit();
}

$host = "localhost";
$dbname = "user_registration";
$username = "root";
$password = "";

try {
    $conn = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $first_name  = htmlspecialchars($_POST['first_name']);
    $last_name   = htmlspecialchars($_POST['last_name']);
    $national_id = htmlspecialchars($_POST['national_id']);

    // مدیریت آپلود تصویر
    $avatar_name = null;
    if (isset($_FILES['avatar']) && $_FILES['avatar']['size'] > 0) {
        $upload_dir = "uploads/";
        $avatar_name = uniqid() . "_" . basename($_FILES['avatar']['name']);
        $upload_path = $upload_dir . $avatar_name;

        move_uploaded_file($_FILES['avatar']['tmp_name'], $upload_path);
    }

    // بروزرسانی اطلاعات در دیتابیس
    if ($avatar_name) {
        $stmt = $conn->prepare("UPDATE users SET first_name = :first_name, last_name = :last_name, national_id = :national_id, avatar = :avatar WHERE id = :id");
        $stmt->execute([
            ':first_name' => $first_name,
            ':last_name' => $last_name,
            ':national_id' => $national_id,
            ':avatar' => $avatar_name,
            ':id' => $_SESSION['user_id']
        ]);
    } else {
        $stmt = $conn->prepare("UPDATE users SET first_name = :first_name, last_name = :last_name, national_id = :national_id WHERE id = :id");
        $stmt->execute([
            ':first_name' => $first_name,
            ':last_name' => $last_name,
            ':national_id' => $national_id,
            ':id' => $_SESSION['user_id']
        ]);
    }

    header("Location: dashboard.php");
    exit();

} catch (PDOException $e) {
    echo "خطا در بروزرسانی: " . $e->getMessage();
}
?>
