<?php
$pin = '7332EB48DAF57BEC8B';
$transid = $_POST['transid'] ?? '';
$amount = 'مقدار تراکنش ذخیره‌شده در دیتابیس یا سشن'; // امنیتی

$data = [
    'pin' => $pin,
    'amount' => $amount,
    'transid' => $transid
];

$ch = curl_init("https://panel.aqayepardakht.ir/api/v2/verify");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
$response = curl_exec($ch);
$result = json_decode($response);

if ($result->status == 'success') {
    echo "پرداخت موفق! کد رهگیری: " . $result->ref_id;
} else {
    echo "پرداخت ناموفق: " . $result->message;
}
?>
<?php
require 'db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['transid'])) {
    $transid = $_POST['transid'];
    $pin = 'YOUR_GATEWAY_PIN';

    // مرحله 1: بازیابی مبلغ از دیتابیس
    $stmt = $pdo->prepare("SELECT * FROM transactions WHERE transid = ? LIMIT 1");
    $stmt->execute([$transid]);
    $transaction = $stmt->fetch();

    if (!$transaction) {
        die("تراکنش یافت نشد.");
    }

    $amount = $transaction['amount'];

    // مرحله 2: ارسال به API تأیید پرداخت
    $data = ['pin' => $pin, 'amount' => $amount, 'transid' => $transid];
    $ch = curl_init('https://panel.aqayepardakht.ir/api/v2/verify');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    $response = curl_exec($ch);
    curl_close($ch);

    $result = json_decode($response);

    if ($result->status == 'success' && $result->code == 1) {
        // بروزرسانی دیتابیس
        $stmt = $pdo->prepare("UPDATE transactions SET status = 'paid', ref_id = ? WHERE transid = ?");
        $stmt->execute([$result->ref_id, $transid]);

        echo "✅ پرداخت موفق بود. شماره پیگیری: " . $result->ref_id;
    } else {
        $stmt = $pdo->prepare("UPDATE transactions SET status = 'failed' WHERE transid = ?");
        $stmt->execute([$transid]);

        echo "❌ پرداخت ناموفق بود. پیام: " . $result->message;
    }
} else {
    echo "درخواست نامعتبر.";
}
?>
