<?php
session_start();
include('db_connection.php');  // اتصال به دیتابیس

// فرض بر این است که کاربر وارد حساب خود شده است و user_id او در سشن ذخیره شده است
$user_id = $_SESSION['user_id'];  // شناسه کاربر

// دریافت محصولات از سبد خرید
$sql = "SELECT p.product_name, p.product_price, c.quantity
        FROM cart c
        JOIN products p ON c.product_id = p.product_id
        WHERE c.user_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

echo "<h2>سبد خرید شما:</h2>";
$total = 0;

while ($row = $result->fetch_assoc()) {
    $product_total = $row['product_price'] * $row['quantity'];
    $total += $product_total;

    echo "<div>";
    echo "<h3>" . $row['product_name'] . "</h3>";
    echo "<p>قیمت واحد: " . number_format($row['product_price']) . " تومان</p>";
    echo "<p>تعداد: " . $row['quantity'] . "</p>";
    echo "<p>مبلغ کل: " . number_format($product_total) . " تومان</p>";
    echo "</div>";
}

echo "<h3>مجموع کل: " . number_format($total) . " تومان</h3>";
?>
