<?php
session_start();
require 'db.php';

// چک کردن اینکه کاربر وارد شده است یا خیر
if (!isset($_SESSION['user_logged_in'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id']; // شناسه کاربر از سشن

// دریافت پیام‌های مربوط به کاربر
$stmt = $pdo->prepare("SELECT * FROM messages WHERE user_id = ? ORDER BY created_at DESC");
$stmt->execute([$user_id]);
$messages = $stmt->fetchAll();

// تغییر وضعیت پیام‌ها به "خوانده شده"
$stmt = $pdo->prepare("UPDATE messages SET status = 'read' WHERE user_id = ?");
$stmt->execute([$user_id]);
?>

<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <title>پیام‌های شما</title>
</head>
<body>
    <h2>💬 پیام‌های شما</h2>
    <?php if (count($messages) > 0): ?>
        <table border="1" width="100%">
            <tr>
                <th>متن پیام</th>
                <th>تاریخ ارسال</th>
                <th>وضعیت</th>
            </tr>
            <?php foreach ($messages as $message): ?>
                <tr>
                    <td><?= htmlspecialchars($message['message']) ?></td>
                    <td><?= $message['created_at'] ?></td>
                    <td><?= $message['status'] == 'unread' ? '未خوانده' : 'خوانده شده' ?></td>
                </tr>
            <?php endforeach; ?>
        </table>
    <?php else: ?>
        <p>شما هیچ پیامی ندارید.</p>
    <?php endif; ?>
</body>
</html>
