<?php
require 'db.php';
if (!isset($_SESSION['user_id'])) header("Location: login.php");

$stmt = $pdo->prepare("SELECT username, balance FROM users WHERE id = ?");
$stmt->execute([$_SESSION['user_id']]);
$user = $stmt->fetch();
?>
<h2>خوش آمدی <?php echo $user['username']; ?></h2>
<p>موجودی کیف پول: <?php echo $user['balance']; ?> تومان</p>

<a href="payment_form.php">شارژ کیف پول</a> |
<a href="logout.php">خروج</a>
<?php
require 'db.php';

// فیلتر اختیاری بر اساس وضعیت
$status = $_GET['status'] ?? null;
$query = "SELECT * FROM transactions";
$params = [];

if (in_array($status, ['pending', 'paid', 'failed'])) {
    $query .= " WHERE status = ?";
    $params[] = $status;
}

$query .= " ORDER BY created_at DESC";

$stmt = $pdo->prepare($query);
$stmt->execute($params);
$transactions = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>داشبورد مدیریت پرداخت‌ها</title>
    <style>
        body { font-family: Tahoma; direction: rtl; }
        table { border-collapse: collapse; width: 100%; margin-top: 20px; }
        th, td { border: 1px solid #ccc; padding: 8px; text-align: center; }
        th { background-color: #f4f4f4; }
        .filter a { margin: 0 10px; text-decoration: none; color: blue; }
    </style>
</head>
<body>

<h2>📋 داشبورد مدیریت پرداخت‌ها</h2>

<div class="filter">
    <strong>فیلتر بر اساس وضعیت:</strong>
    <a href="dashboard.php">همه</a> |
    <a href="dashboard.php?status=pending">در انتظار</a> |
    <a href="dashboard.php?status=paid">پرداخت‌شده</a> |
    <a href="dashboard.php?status=failed">ناموفق</a>
</div>

<table>
    <tr>
        <th>شناسه</th>
        <th>مبلغ (تومان)</th>
        <th>موبایل</th>
        <th>TransID</th>
        <th>Ref ID</th>
        <th>وضعیت</th>
        <th>تاریخ</th>
    </tr>
    <?php foreach ($transactions as $row): ?>
        <tr>
            <td><?= $row['id'] ?></td>
            <td><?= number_format($row['amount']) ?></td>
            <td><?= htmlspecialchars($row['mobile']) ?></td>
            <td><?= htmlspecialchars($row['transid']) ?></td>
            <td><?= htmlspecialchars($row['ref_id']) ?></td>
            <td>
                <?php
                    switch ($row['status']) {
                        case 'paid': echo '✅ پرداخت‌شده'; break;
                        case 'pending': echo '⏳ در انتظار'; break;
                        case 'failed': echo '❌ ناموفق'; break;
                    }
                ?>
            </td>
            <td><?= $row['created_at'] ?></td>
        </tr>
    <?php endforeach; ?>
</table>

</body>
</html>
